import matplotlib.pyplot as plt
import matplotlib as mpl
import numpy as np


def get_data_ax1():
	f1 = open('correct_data_ax1.txt','r')
	f2 = open('mutated_data_omit.txt','r')
	line1 = [i.strip() for i in f1.readlines()]
	line2 = [i.strip() for i in f2.readlines()]
	f1.close()
	f2.close()

	c_x = np.array([int(i.split('\t')[0]) for i in line1])
	c_y = np.array([int(i.split('\t')[1]) for i in line1])
	m_x = np.array([int(i.split('\t')[0]) for i in line2])
	m_y = np.array([int(i.split('\t')[1]) for i in line2])

	return c_x,c_y,m_x,m_y

def get_data_ax2():
	f1 = open('correct_data_ax2.txt','r')
	line1 = [i.strip() for i in f1.readlines()]
	f1.close()

	c_x = np.array([int(i.split('\t')[0]) for i in line1])
	c_y = np.array([int(i.split('\t')[1]) for i in line1])

	return c_x,c_y

def get_data_ax3():
	f1 = open('correct_data_ax3.txt','r')
	line1 = [i.strip() for i in f1.readlines()]
	f1.close()

	c_x = np.array([int(i.split('\t')[0]) for i in line1])
	c_y = np.array([int(i.split('\t')[1]) for i in line1])

	return c_x,c_y

def plot_ax1():
	correct_ax1_x,correct_ax1_y = get_data_ax1()[0],get_data_ax1()[1]
	mutated_ax1_x,mutated_ax1_y = get_data_ax1()[2],get_data_ax1()[3]
	fig,ax1 = plt.subplots(1,1,figsize=(5,5))
	ax1.bar(correct_ax1_x,correct_ax1_y,color='Orange',width=1.0)
	ax1.bar(mutated_ax1_x,mutated_ax1_y,color='green',alpha=0.5,width=1.0)
	ax1.spines['top'].set_visible(False)
	ax1.spines['right'].set_visible(False)
	ax1.spines['bottom'].set_visible(False)
	plt.savefig('ax1.pdf',format='pdf')
	plt.show()

def plot_ax2():
	correct_ax2_x,correct_ax2_y = get_data_ax2()[0],get_data_ax2()[1]
	fig,ax1 = plt.subplots(1,1,figsize=(5,5))
	ax1.bar(correct_ax2_x,correct_ax2_y,color='DarkOrange',width=1.0)
	ax1.spines['top'].set_visible(False)
	ax1.spines['right'].set_visible(False)
	ax1.spines['bottom'].set_visible(False)
	plt.savefig('ax2.pdf',format='pdf')
	plt.show()

def plot_ax3():
	correct_ax3_x,correct_ax3_y = get_data_ax3()[0],get_data_ax3()[1]
	fig,ax1 = plt.subplots(1,1,figsize=(5,5))
	ax1.bar(correct_ax3_x,correct_ax3_y,color='Chocolate',width=1.0)
	ax1.spines['top'].set_visible(False)
	ax1.spines['right'].set_visible(False)
	ax1.spines['bottom'].set_visible(False)
	plt.savefig('ax3.pdf',format='pdf')
	plt.show()


plot_ax3()